<?php
require_once(APPROOT . 'collectors/CheckmkOSFamilyCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkOSVersionCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkBrandCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkModelCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkPCCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkServerCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkPhysicalInterfaceCollector.class.inc.php');

require_once(APPROOT . 'collectors/CheckmkSoftwareCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkDBServerCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkMiddlewareCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkOtherSoftwareCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkPCSoftwareCollector.class.inc.php');
require_once(APPROOT . 'collectors/CheckmkWebServerCollector.class.inc.php');
$idx = 1;
Orchestrator::AddCollector($idx++, 'CheckmkOSFamilyCollector');
Orchestrator::AddCollector($idx++, 'CheckmkOSVersionCollector');
Orchestrator::AddCollector($idx++, 'CheckmkBrandCollector');
Orchestrator::AddCollector($idx++, 'CheckmkModelCollector');
Orchestrator::AddCollector($idx++, 'CheckmkPCCollector');
Orchestrator::AddCollector($idx++, 'CheckmkServerCollector');
Orchestrator::AddCollector($idx++, 'CheckmkPhysicalInterfaceCollector');

//check if software import is enabled
$sImportSoftware = Utils::GetConfigurationValue('import_software_packages', 'no');
if (($sImportSoftware != 'yes') && ($sImportSoftware != 'no'))
{
	Utils::Log(LOG_WARNING, "Unexpected value '$sImportSoftware' for the parameter 'import_software_packages'. Will NOT import software packages. The expected values for this parameter are 'yes' or 'no'.");
}
//import software if import is enabled
else if ($sImportSoftware == 'yes'){
	Orchestrator::AddCollector($idx++, 'CheckmkSoftwareCollector');
	Orchestrator::AddCollector($idx++, 'CheckmkDBServerCollector');
	Orchestrator::AddCollector($idx++, 'CheckmkMiddlewareCollector');
	Orchestrator::AddCollector($idx++, 'CheckmkOtherSoftwareCollector');
	Orchestrator::AddCollector($idx++, 'CheckmkPCSoftwareCollector');
	Orchestrator::AddCollector($idx++, 'CheckmkWebServerCollector');
}
?>