<?php
require_once(APPROOT.'collectors/SlackJSONParser.php');
require_once(APPROOT.'collectors/utils.php');
require_once(APPROOT.'collectors/CheckmkCollector.class.inc.php');
class CheckmkSoftwareCollector extends CheckmkCollector
{
    private $idx = -1;
    private $aSoftwares = null;
    private $softwareVendorMap;
    private $softwareTypeMap;

    public function Prepare()
    {
        $bRes = parent::Prepare();

        $this->emptyRow = array('primary_key' => '',
                                'name' => '',
                                'type' => '',
                                'vendor' => '',
                                'version'=> '',
                                'documents_list' => ''
        );

        $this->softwareVendorMap = new MappingTable('softwarevendor_mapping');
        $this->softwareTypeMap = new MappingTable('sw_type_mapping');

        return $bRes;
    }

    // Note: each host may have multiple softwares, to handle this an array
    // ($this->aSoftwares) and index ($this->idx) are maintained and linked
    // to the host by the host's primary key (hostname)
    public function Fetch()
    {
        // Try to get adapter list as required/available
        if ($this->aSoftwares === null || $this->idx == -1)
        {
            $data = $this->getData();
            if ($data === null)       // Couldn't get any data
                return $this->emptyRow;
            else if ($data === false) // End of data
                return false;

            if (isset($data->software->packages))
            {
                $this->idx = 0;
                $this->aSoftwares = $data->software->packages;
            }
            else // Couldn't get network adapter data
                return $this->emptyRow;
        }

        if ($this->idx >= count($this->aSoftwares))
        {
            $this->aSoftwares = null;
            $this->idx = -1;
            return $this->emptyRow;
        }

        $software = $this->aSoftwares[$this->idx++];
        if (isset($software->package_type))
        {
            //get vendor by package_type
            $vendor = $this->softwareVendorMap->MapValue($software->package_type, '');
            //Ignore packages without matching vendor
            if($vendor !== ''){
                $primary_key = trim($software->name) . "_" . trim($software->version);

                //get software type by name, default is OtherSoftware
                $software_type = $this->softwareTypeMap->MapValue($software->name, 'OtherSoftware');
                if(!in_array($software_type, array('DBServer','Middleware','OtherSoftware','PCSoftware','WebServer'))){
                    Utils::Log(LOG_WARNING, 'Unexpected Spftware type (' . $software_type . ') in Configuration File. Please check your Config. Software type is set to OtherSoftware for this package');
                    $software_type = 'OtherSoftware';
                }

                return array('primary_key' => $primary_key,
                                'name' => trim($software->name),
                                'type' => $software_type,
                                'vendor' => $vendor,
                                'version'=> trim($software->version),
                                'documents_list' => ''
                );
            }
        }
        return $this->emptyRow;
    }

        public function AttributeIsOptional($sAttCode)
    {
        if ($sAttCode == 'name' || $sAttCode == 'vendor' || $sAttCode == 'version')
            return false;
        else
            return true;
    }

    protected function MustProcessBeforeSynchro()
    {
        return true;
    }

    protected function ProcessLineBeforeSynchro(&$lineData, $lineIdx)
    {
        if ($lineIdx > 0 && $lineData[0] === '')
            throw new IgnoredRowException('No software was found');
    }
}
?>