<?php
require_once(APPROOT.'collectors/SlackJSONParser.php');
require_once(APPROOT.'collectors/utils.php');
require_once(APPROOT.'collectors/CheckmkCollector.class.inc.php');
class CheckmkSoftwareInstanceCollector extends CheckmkCollector
{
    private $defaultOrg = 0;
    private $useNetworkHostname = true;

    private $defaultFields;
    private $idx = -1;
    private $aSoftwareInstances = null;
    private $softwareVendorMap;
    private $softwareTypeMap;
    private $softwareLookup;
    private $system_id;
    protected $finalclass;

    public function Prepare()
    {
        $bRes = parent::Prepare();

        $this->useNetworkHostname = getBooleanConfVal('use_network_hostname',
                                                      false);

        $this->defaultOrg = Utils::GetConfigurationValue('default_org_id');
        $this->defaultFields = Utils::GetConfigurationValue('default_fields_sw', array());
        $this->softwareVendorMap = new MappingTable('softwarevendor_mapping');
        $this->softwareTypeMap = new MappingTable('sw_type_mapping');
        $this->emptyRow = array('primary_key' => '',
                                'name' => '',
                                'org_id' => '',
                                'software_id' => '',
                                'system_id' => ''
        );
        foreach ($this->defaultFields as $fieldName => $value)
        {
            $this->emptyRow[$fieldName] = '';
        }

        return $bRes;
    }

    // Note: each host may have multiple software instances, to handle this an array
    // ($this->aSoftwareInstances) and index ($this->idx) are maintained and linked
    // to the host by the host's primary key (hostname)
    public function Fetch()
    {
        // Try to get software instance list as required/available
        if ($this->aSoftwareInstances === null || $this->idx == -1)
        {
            $data = $this->getData();
            if ($data === null)       // Couldn't get any data
                return $this->emptyRow;
            else if ($data === false) // End of data
                return false;

            if (isset($data->software->packages))
            {
                $this->idx = 0;
                $this->aSoftwareInstances = $data->software->packages;
                $this->system_id = $this->hostname();
                if ($this->useNetworkHostname && isset($data->networking->hostname))
                    $this->system_id = $data->networking->hostname;
            }
            else // Couldn't get software instance data
                return $this->emptyRow;
        }

        if ($this->idx >= count($this->aSoftwareInstances))
        {
            $this->aSoftwareInstances = null;
            $this->idx = -1;
            return $this->emptyRow;
        }

        $software = $this->aSoftwareInstances[$this->idx++];

        if (isset($software->package_type))
        {
            //get vendor by package_type
            $vendor = $this->softwareVendorMap->MapValue($software->package_type, '');
            
            //get software type by name, default is OtherSoftware
            $software_type = $this->softwareTypeMap->MapValue($software->name, 'OtherSoftware');
            if(!in_array($software_type, array('DBServer','Middleware','OtherSoftware','PCSoftware','WebServer'))){
                $software_type = 'OtherSoftware';
            }

            //ignore software packages without matching vendor or diffrent finalclass
            if($vendor !== '' && $software_type === $this->finalclass){
                $software_primary_key = trim($software->name) . "_" . trim($software->version);
                $primary_key = $this->system_id . "_" . $software_primary_key;
                $ret = array('primary_key' => $primary_key,
                                'name' => trim($software->name) . "_" . $this->system_id,
                                'org_id' => $this->defaultOrg,
                                'software_id' => trim($software->name) . " " .trim($software->version),
                                'system_id' => $this->system_id
                );
                // Add fields for which a default is specified
                foreach ($this->defaultFields as $fieldName => $value)
                {
                    $ret[$fieldName] = $value;
                }
                return $ret;
            }
        }
        return $this->emptyRow;
    }

    public function AttributeIsOptional($sAttCode)
    {
        if ($sAttCode == 'name' || $sAttCode == 'org_id' || $sAttCode == 'system_id')
            return false;
        else
            return true;
    }

    protected function MustProcessBeforeSynchro()
    {
        return true;
    }

    protected function InitProcessBeforeSynchro()
    {
        $this->softwareLookup =
            new LookupTable('SELECT Software WHERE type = "'.$this->finalclass.'"',
                            array('friendlyname'));
    }

    protected function ProcessLineBeforeSynchro(&$lineData, $lineIdx)
    {
        if ($lineIdx > 0 && $lineData[0] === '')
            throw new IgnoredRowException('No ' . $this->finalclass . ' was found');
        $this->softwareLookup->Lookup($lineData,
                                       array('software_id'),
                                       'software_id',
                                       $lineIdx);
    }
}
?>